<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblVesselServiceReportTable extends Migration {

	public function up()
	{
		Schema::create('tbl_vessel_service_report', function(Blueprint $table) {
			$table->increments('vessel_service_report_id', true);
			$table->integer('vessel_id')->unsigned();
			$table->integer('vessel_equipment_type_id')->unsigned()->nullable();
			$table->string('vessel_service_report_name', 100);
			$table->date('vessel_service_report_date');
			$table->timestamp('vessel_service_report_created');
			$table->timestamp('vessel_service_report_updated');
			$table->timestamp('vessel_service_report_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_vessel_service_report');
	}
}