<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 60);
			$table->text('description');
			$table->string('project_uri', 255)->unique();
			$table->integer('user_id')->unsigned();
			$table->string('url', 255)->unique()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}