<?php

namespace App\models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CompanyUser extends Eloquent {

	protected $table = 'company_users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company()
	{
		return $this->belongsTo('App\models\Company');
	}

	public function roles()
	{
		return $this->belongsToMany('App\models\Role')withPivot('user_id','role_id');
	}

}