<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('patient_name');
			$table->integer('patient_age');
			$table->integer('blood_type_id');
			$table->integer('bags_num');
			$table->string('hospital_address');
			$table->string('hospital_name');
			$table->integer('city_id');
			$table->string('phone');
			$table->float('longitude', 10.8);
			$table->float('latitude', 10.8);
			$table->integer('client_id');
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}