<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->decimal('amount', 10,2);
			$table->enum('payment_method', array('credit-card'', 'bank-transfer', 'cash', 'collector'));
			$table->datetime('payment_date');
			$table->enum('status', array('successful', 'failed', 'pending'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}