<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('payment_id')->unsigned();
			$table->decimal('amount', 10,2);
			$table->date('invoice_date');
			$table->date('due_date');
			$table->enum('status', array('paid', 'unpaid', 'partial'));
			$table->json('items');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}