<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->bigInteger('request_types_id')->unsigned();
			$table->bigInteger('payment_id')->unsigned();
			$table->json('details')->nullable();
			$table->enum('status', array('pending', 'approved', 'rejected', 'completed'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}