<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSmsPackagesTable extends Migration {

	public function up()
	{
		Schema::create('sms_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('quantity');
			$table->decimal('price', 10,2);
			$table->enum('status', array('active', 'expired'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sms_packages');
	}
}