<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserServicesTable extends Migration {

	public function up()
	{
		Schema::create('user_services', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->json('data');
			$table->enum('status', array(''active'', ''on-hold'', ''expired''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_services');
	}
}