<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('full_name');
			$table->string('phone');
			$table->string('email');
			$table->string('password');
			$table->string('avatar');
			$table->boolean('is_owner');
			$table->bigInteger('role_id')->unsigned();
			$table->bigInteger('parent_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}