<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePerformancesTable extends Migration {

	public function up()
	{
		Schema::create('performances', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('unit_id')->unsigned()->index();
			$table->integer('skill_id')->unsigned()->index();
			$table->integer('current_combo')->nullable();
			$table->integer('longest_combo')->nullable();
			$table->integer('elapsed_time');
			$table->integer('question_count');
			$table->integer('right_answer_count');
			$table->integer('skipped_answer_count');
			$table->timestamp('start_at');
			$table->timestamp('end_at');
			$table->boolean('is_log');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('performances');
	}
}