<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('barnd_id')->unsigned();
			$table->string('filename');
			$table->string('post_url');
			$table->integer('likes');
			$table->integer('comments');
			$table->string('description');
			$table->bigInteger('product_id')->unsigned()->nullable();
			$table->bigInteger('brand_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->text('tags')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}