<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->float('amount')->nullable();
			$table->string('type')->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->string('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}