<?php

namespace TicketTracker;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Queue extends Model 
{

    protected $table = 'Queues';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tickets()
    {
        return $this->hasMany('TicketTracker\Ticket', 'queueId');
    }

}