<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('site_id')->unsigned();
			$table->string('url');
			$table->string('title')->nullable();
			$table->longText('description')->nullable();
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}