<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('specializations_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('specializations_users', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('specializations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('consultation_place_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_submissions', function(Blueprint $table) {
			$table->foreign('userId')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_submissions', function(Blueprint $table) {
			$table->foreign('food_plan_id')->references('id')->on('food_plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_plans', function(Blueprint $table) {
			$table->foreign('patientID')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_plans', function(Blueprint $table) {
			$table->foreign('doctorId')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('nutrition_lists', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('nutrition_summarys', function(Blueprint $table) {
			$table->foreign('nutrition_list_id')->references('id')->on('nutrition_lists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_plan_details', function(Blueprint $table) {
			$table->foreign('food_plan_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_plan_details', function(Blueprint $table) {
			$table->foreign('nutrition_summary_id')->references('id')->on('nutrition_summarys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('doctor_patient', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('doctor_patient', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('specializations_users', function(Blueprint $table) {
			$table->dropForeign('specializations_users_user_id_foreign');
		});
		Schema::table('specializations_users', function(Blueprint $table) {
			$table->dropForeign('specializations_users_specialization_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_user_id_foreign');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->dropForeign('credits_user_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_doctor_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_patient_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_consultation_place_id_foreign');
		});
		Schema::table('food_submissions', function(Blueprint $table) {
			$table->dropForeign('food_submissions_userId_foreign');
		});
		Schema::table('food_submissions', function(Blueprint $table) {
			$table->dropForeign('food_submissions_food_plan_id_foreign');
		});
		Schema::table('food_plans', function(Blueprint $table) {
			$table->dropForeign('food_plans_patientID_foreign');
		});
		Schema::table('food_plans', function(Blueprint $table) {
			$table->dropForeign('food_plans_doctorId_foreign');
		});
		Schema::table('nutrition_lists', function(Blueprint $table) {
			$table->dropForeign('nutrition_lists_doctor_id_foreign');
		});
		Schema::table('nutrition_summarys', function(Blueprint $table) {
			$table->dropForeign('nutrition_summarys_nutrition_list_id_foreign');
		});
		Schema::table('food_plan_details', function(Blueprint $table) {
			$table->dropForeign('food_plan_details_food_plan_id_foreign');
		});
		Schema::table('food_plan_details', function(Blueprint $table) {
			$table->dropForeign('food_plan_details_nutrition_summary_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_sender_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_receiver_id_foreign');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->dropForeign('recommendations_patient_id_foreign');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->dropForeign('recommendations_doctor_id_foreign');
		});
		Schema::table('doctor_patient', function(Blueprint $table) {
			$table->dropForeign('doctor_patient_patient_id_foreign');
		});
		Schema::table('doctor_patient', function(Blueprint $table) {
			$table->dropForeign('doctor_patient_doctor_id_foreign');
		});
	}
}