<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerHasMerchantsTable extends Migration {

	public function up()
	{
		Schema::create('customer_has_merchants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('marchant_id')->unsigned();
			$table->float('credit')->nullable();
			$table->boolean('newsletter')->default(0);
			$table->integer('fidelity_points')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('customer_has_merchants');
	}
}