<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_lotteries', function(Blueprint $table) {
			$table->foreign('lottery_id')->references('id')->on('lotteries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('chance_logs', function(Blueprint $table) {
			$table->foreign('lottery_id')->references('id')->on('lotteries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_lotteries', function(Blueprint $table) {
			$table->dropForeign('user_lotteries_lottery_id_foreign');
		});
		Schema::table('chance_logs', function(Blueprint $table) {
			$table->dropForeign('chance_logs_lottery_id_foreign');
		});
	}
}