<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationSettingsTable extends Migration {

	public function up()
	{
		Schema::create('application_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('key', 150)->unique()->nullable();
			$table->enum('platform', array('all', 'web', 'android', 'ios'));
			$table->string('value', 150)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('application_settings');
	}
}