<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Barcode extends Eloquent {

	protected $table = 'order_barcodes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('barcode');
	protected $visible = array('barcode');

	public function order()
	{
		return $this->belongsTo('App\Models\Order');
	}

}