<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('creator_user_id', 'status_id', 'order_type_id', 'operation_status_id', 'cargo_firm_integration_id', 'company_warehouse_id', 'uuid', 'name', 'tracking_number', 'special_tracking_number', 'items_count', 'reference_number', 'reference_number2', 'reference_number3', 'order_price_3rd', 'second_estimated_at', 'cargo_created_at');
	protected $visible = array('creator_user_id', 'status_id', 'order_type_id', 'operation_status_id', 'cargo_firm_integration_id', 'company_warehouse_id', 'uuid', 'name', 'tracking_number', 'special_tracking_number', 'items_count', 'reference_number', 'reference_number2', 'reference_number3', 'order_price_3rd', 'second_estimated_at', 'cargo_created_at');

	public function logs()
	{
		return $this->hasMany('Log');
	}

	public function receiver()
	{
		return $this->hasOne('App\Models\Order\Receiver');
	}

	public function location()
	{
		return $this->hasOne('App\Models\Order\Location');
	}

	public function items()
	{
		return $this->hasMany('App\Models\Order\Item');
	}

	public function requestErrors()
	{
		return $this->hasMany('App\Models\Order\RequestError');
	}

	public function requests()
	{
		return $this->hasMany('App\Models\Order\Request');
	}

	public function status()
	{
		return $this->belongsTo('App\Models\Situation');
	}

	public function operationStatus()
	{
		return $this->belongsTo('App\Models\Situation', 'operation_status_id');
	}

	public function cargoIntegration()
	{
		return $this->belongsTo('App\Models\Cargo\Integration');
	}

	public function warehouse()
	{
		return $this->belongsTo('App\Models\Company\Warehouse');
	}

	public function notes()
	{
		return $this->hasMany('App\Models\Order\Notes');
	}

}