<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'user_id', 'last_replied_at', 'last_seen_at', 'subject');
	protected $visible = array('order_id', 'user_id', 'last_replied_at', 'last_seen_at', 'subject');

	public function message()
	{
		return $this->hasOne('TicketMessage');
	}

}