<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('is_active')->default(true);
			$table->string('code');
			$table->text('notes')->nullable();
			$table->timestamp('starts_at')->nullable();
			$table->timestamp('ends_at')->nullable();
			$table->double('discount');
			$table->boolean('discount_renewals')->default(false);
			$table->enum('apply_to_payment', array('first_payment_only', 'first_payment_and_renewals'));
			$table->boolean('one_redemption_per_user')->default(false);
			$table->integer('total_redemptions_limit')->nullable();
			$table->enum('who_can_use', array('all_users', 'new_customers', 'previous_customers', 'current_customers', 'current_previous_customers'));
			$table->enum('apply_to_plan', array('all_plans', 'specific_plans'));
			$table->string('specific_plans')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}