<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentGatewaysTable extends Migration {

	public function up()
	{
		Schema::create('payment_gateways', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('icon')->nullable();
			$table->boolean('enable_gateway')->default(false);
			$table->enum('mode', array('live', 'sandbox'));
			$table->string('currency', 20)->nullable();
			$table->string('currency_locale', 20)->nullable();
			$table->double('tax_rate')->nullable();
			$table->string('base_url')->nullable();
			$table->string('api_key_live')->nullable();
			$table->string('api_secret_live');
			$table->string('api_key_sandbox')->nullable();
			$table->string('api_secret_sandbox')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment_gateways');
	}
}