<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('ticket_category_id')->unsigned();
			$table->bigInteger('ticket_priority_id')->unsigned();
			$table->string('ticket_status')->nullable();
			$table->string('conversation_id')->nullable();
			$table->string('user_email');
			$table->string('user_name')->nullable();
			$table->string('user_phone')->nullable();
			$table->string('subject');
			$table->text('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}