<?php

namespace App;

class Collaborateur extends Eloquent {

	protected $table = 'collaborateurs';
	public $timestamps = true;
	protected $fillable = array('prenom', 'nom', 'initiales', 'date_arrivee', 'date_depart', 'salaire', 'infos');

	public function type_collaborateur()
	{
		return $this->belongsTo('App\TypeCollaborateur');
	}

	public function evenements()
	{
		return $this->hasMany('App\Evenement');
	}

	public function deplacements()
	{
		return $this->hasMany('App\Deplacement');
	}

	public function charges()
	{
		return $this->hasMany('App\Charge');
	}

	public function vehicule()
	{
		return $this->hasOne('App\Vehicule');
	}

	public function candidatures()
	{
		return $this->hasMany('App\Candidature');
	}

}