<?php

namespace App;

class Projet extends Eloquent {

	protected $table = 'projets';
	public $timestamps = true;
	protected $fillable = array('denomination_courte', 'denomination', 'adresse', 'complement_adresse', 'code_postal', 'ville', 'infos');

	public function type_projet()
	{
		return $this->belongsTo('App\TypeProjet');
	}

	public function client()
	{
		return $this->belongsTo('App\Client');
	}

	public function phases()
	{
		return $this->hasMany('App\Phase');
	}

	public function partenaires()
	{
		return $this->belongsToMany('App\Partenaire');
	}

}