<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActsTable extends Migration {

	public function up()
	{
		Schema::create('acts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->tinyInteger('status')->nullable();
			$table->date('date');
			$table->datetime('start_datetime')->nullable();
			$table->datetime('end_datetime')->nullable();
			$table->integer('place_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('acts');
	}
}