<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActConfigurationsTable extends Migration {

	public function up()
	{
		Schema::create('act_configurations', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('debug');
			$table->boolean('debug_hls_in_console');
			$table->boolean('hide_console_output');
			$table->string('page_title');
			$table->boolean('use_cdn')->default(true);
			$table->string('use_cdn_map_from')->nullable();
			$table->string('use_cdn_map_to')->nullable();
			$table->boolean('hide_pip_at_start');
			$table->boolean('pip_muted');
			$table->boolean('current_video_muted');
			$table->boolean('hide_main_audio');
			$table->boolean('hide_pip_audio');
			$table->boolean('hide_pip_video');
			$table->boolean('stretch_to_fit_hd_video');
			$table->boolean('stream_capacity_full');
			$table->boolean('show_spinner');
			$table->smallInteger('spin_horizontal');
			$table->smallInteger('spin_vertical');
			$table->boolean('password_required');
			$table->string('encoded_password');
			$table->string('secure_ref_url');
			$table->json('back_button_for_url');
			$table->boolean('buffer_debug');
			$table->smallInteger('resync_total_count_warning');
			$table->smallInteger('resync_check_freq');
			$table->double('resync_diff_allowance', 4,2)->default('1.5');
			$table->smallInteger('max_loading_delay');
			$table->smallInteger('max_max_buffer_length');
			$table->string('placeholder_360_video');
			$table->string('placeholder');
			$table->string('brand_logo');
			$table->string('brand_color');
			$table->string('call_to_action_color');
			$table->string('favicon');
			$table->string('brand_name');
			$table->smallInteger('logo_max_height_mobile');
			$table->boolean('enable_camera_blankout')->default(false);
			$table->string('network_error_placeholder')->nullable();
			$table->smallInteger('fov_desktop');
			$table->smallInteger('fov_mobile_portrait');
			$table->smallInteger('fov_mobile_landscape');
			$table->smallInteger('zoom_mobile_portrait');
			$table->boolean('show_ads');
			$table->bigInteger('act_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->timestamps();
			$table->bigInteger('config_event_id')->unsigned();
			$table->bigInteger('config_customer_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('act_configurations');
	}
}