<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acts', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acts', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('actors', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('actors', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('camera_locations', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transmission_boxes', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stream_url_endpoints', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('act_assigned_actors', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('act_assigned_actors', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('act_assigned_data', function(Blueprint $table) {
			$table->foreign('act_id')->references('id')->on('acts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('act_assigned_data', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->foreign('act_id')->references('id')->on('acts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->foreign('config_event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->foreign('config_customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('player_ads', function(Blueprint $table) {
			$table->foreign('act_id')->references('id')->on('acts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('player_ads', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('incidents', function(Blueprint $table) {
			$table->foreign('act_assigned_data_id')->references('id')->on('act_assigned_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_customer_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_customer_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_location_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_customer_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_event_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_customer_id_foreign');
		});
		Schema::table('acts', function(Blueprint $table) {
			$table->dropForeign('acts_place_id_foreign');
		});
		Schema::table('acts', function(Blueprint $table) {
			$table->dropForeign('acts_customer_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_customer_id_foreign');
		});
		Schema::table('actors', function(Blueprint $table) {
			$table->dropForeign('actors_team_id_foreign');
		});
		Schema::table('actors', function(Blueprint $table) {
			$table->dropForeign('actors_customer_id_foreign');
		});
		Schema::table('camera_locations', function(Blueprint $table) {
			$table->dropForeign('camera_locations_customer_id_foreign');
		});
		Schema::table('transmission_boxes', function(Blueprint $table) {
			$table->dropForeign('transmission_boxes_customer_id_foreign');
		});
		Schema::table('stream_url_endpoints', function(Blueprint $table) {
			$table->dropForeign('stream_url_endpoints_customer_id_foreign');
		});
		Schema::table('act_assigned_actors', function(Blueprint $table) {
			$table->dropForeign('act_assigned_actors_team_id_foreign');
		});
		Schema::table('act_assigned_actors', function(Blueprint $table) {
			$table->dropForeign('act_assigned_actors_customer_id_foreign');
		});
		Schema::table('act_assigned_data', function(Blueprint $table) {
			$table->dropForeign('act_assigned_data_act_id_foreign');
		});
		Schema::table('act_assigned_data', function(Blueprint $table) {
			$table->dropForeign('act_assigned_data_customer_id_foreign');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->dropForeign('act_configurations_act_id_foreign');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->dropForeign('act_configurations_customer_id_foreign');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->dropForeign('act_configurations_config_event_id_foreign');
		});
		Schema::table('act_configurations', function(Blueprint $table) {
			$table->dropForeign('act_configurations_config_customer_id_foreign');
		});
		Schema::table('player_ads', function(Blueprint $table) {
			$table->dropForeign('player_ads_act_id_foreign');
		});
		Schema::table('player_ads', function(Blueprint $table) {
			$table->dropForeign('player_ads_customer_id_foreign');
		});
		Schema::table('incidents', function(Blueprint $table) {
			$table->dropForeign('incidents_act_assigned_data_id_foreign');
		});
	}
}