<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ActAssignedData extends Eloquent {

	protected $table = 'act_assigned_data';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('streamable_type', 'assignable_type', 'vod_url', 'aws_medialive_channel_id');

	public function incidents()
	{
		return $this->hasMany('Incident');
	}

}