<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function users()
	{
		return $this->hasMany('App\Model\User');
	}

	public function locations()
	{
		return $this->hasMany('App\Model\Location');
	}

	public function events()
	{
		return $this->hasMany('App\Model\Event');
	}

	public function tracks()
	{
		return $this->hasMany('App\Model\Place');
	}

	public function races()
	{
		return $this->hasMany('App\Model\Act');
	}

	public function teams()
	{
		return $this->hasMany('App\Model\Team');
	}

	public function drivers()
	{
		return $this->hasMany('App\Model\Actor');
	}

	public function camera_locations()
	{
		return $this->hasMany('App\Model\CameraLocation');
	}

	public function transmission_boxes()
	{
		return $this->hasMany('App\Model\TransmissionBox');
	}

	public function stream_url_endpoints()
	{
		return $this->hasMany('App\Model\StreamUrlEndpoints');
	}

	public function act_configurations()
	{
		return $this->hasMany('ActConfiguration');
	}

	public function player_ads()
	{
		return $this->hasMany('PlayerAd');
	}

}