<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Place extends Eloquent {

	protected $table = 'places';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function event()
	{
		return $this->belongsTo('App\Model\Event');
	}

	public function customer()
	{
		return $this->belongsTo('App\Model\Customer');
	}

	public function races()
	{
		return $this->hasMany('App\Model\Act');
	}

}