<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TransmissionBox extends Eloquent {

	protected $table = 'transmission_boxes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('subdomain', 'type');

	public function customer()
	{
		return $this->belongsTo('App\Model\Customer');
	}

}