<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'email_verified_at');
	protected $hidden = array('password');

	public function customer()
	{
		return $this->belongsTo('App\Model\Customer');
	}

}