<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayerAdsTable extends Migration {

	public function up()
	{
		Schema::create('player_ads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title')->nullable();
			$table->smallInteger('start_time');
			$table->string('stream_url')->nullable();
			$table->boolean('show_brand_logo');
			$table->boolean('play_once');
			$table->boolean('allow_video_scrub');
			$table->boolean('hide_skip_ad_button');
			$table->smallInteger('show_ad_skip_seconds');
			$table->string('notice_text');
			$table->boolean('stretch_to_fit_hd_video');
			$table->bigInteger('act_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('player_ads');
	}
}