<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCallInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('call_invitations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->enum('status', array('waiting', 'payed', 'cancel_by_creator', 'cancel_by_user'));
			$table->boolean('is_send')->default(0);
			$table->boolean('is_accepted')->default(0);
			$table->datetime('accepted_at')->nullable();
			$table->bigInteger('call_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('call_invitations');
	}
}