<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLiveParticipantsTable extends Migration {

	public function up()
	{
		Schema::create('live_participants', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->boolean('is_vip')->default(0);
			$table->float('vip_retribution_percent')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('live_id')->unsigned();
			$table->bigInteger('live_invitation_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('live_participants');
	}
}