<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->text('biography')->nullable();
			$table->boolean('is_draft')->default(1);
			$table->boolean('is_comment_activated')->default(1);
			$table->boolean('is_like_activated')->default(1);
			$table->datetime('publication_at')->nullable();
			$table->enum('type', array('photo', 'video'));
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}