<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserThreadMessagesTable extends Migration {

	public function up()
	{
		Schema::create('user_thread_messages', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->text('message');
			$table->boolean('is_read')->default(0);
			$table->bigInteger('user_thread_id')->nullable();
			$table->bigInteger('user_recipient_id')->unsigned();
			$table->bigInteger('user_sender_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_thread_messages');
	}
}