<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('nickname', 100)->unique()->nullable();
			$table->string('email', 150)->unique();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password')->nullable();
			$table->string('provider_id', 50)->nullable();
			$table->string('provider_name', 50)->nullable();
			$table->boolean('is_public')->default(1);
			$table->bigInteger('locale_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}