<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LegalCase extends Eloquent {

	protected $table = 'legal_cases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function legalCaseServiceRequests()
	{
		return $this->hasMany('LegalCaseServiceRequests', 'legal_case_id');
	}

	public function afterSettlement()
	{
		return $this->hasOne('LegalCaseAfterSettlement', 'legal_case_id');
	}

}