<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkshopPromotionItemsTable extends Migration {

	public function up()
	{
		Schema::create('workshop_promotion_items', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('promotion_cart_id')->unsigned()->index();
			$table->bigInteger('workshop_id')->index();
			$table->bigInteger('generation_id')->unsigned()->index();
			$table->date('from');
			$table->date('to');
			$table->decimal('total_price');
			$table->enum('status', array('paid', 'unpaid'))->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('workshop_promotion_items');
	}
}