<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromotionOrdersTable extends Migration {

	public function up()
	{
		Schema::create('promotion_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('member_id')->index();
			$table->bigInteger('promotion_cart_id')->unsigned()->index();
			$table->decimal('total_price');
			$table->enum('status', array('pending', 'paid', 'failed', 'canceled'))->index();
			$table->string('payment_token', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('promotion_orders');
	}
}