<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class InnerCar extends Model 
{

    protected $table = 'inner_cars';
    public $timestamps = true;
    protected $fillable = array('product_id', 'engine_capacity', 'inner_color_id', 'outer_color_id', 'gear_type', 'supplier', 'main_image', 'car_status', 'price', 'have_discount', 'price_after', 'engine_size', 'car_operation', 'ex_bluetooth', 'ex_aux', 'ex_cd', 'ex_navigator', 'ex_back_cam', 'ex_sensor_front', 'ex_sensor_back', 'ex_intellegance_entry', 'ex_sun_roof', 'ex_seat_type', 'notes', 'new_or_used');

    public function parentProduct()
    {
        return $this->belongsTo('App\Product');
    }

    public function orders()
    {
        return $this->hasMany('App\Order');
    }

    public function innerColor()
    {
        return $this->belongsTo('App\CarColor', 'inner_car_id');
    }

    public function outer_color()
    {
        return $this->belongsTo('App\CarColor', 'outer_color_id');
    }

    public function notification()
    {
        return $this->morphMany('App\Notification', 'notifiable');
    }

}