<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tercero extends Eloquent {

	protected $table = 'terceros';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function tipo_identificaion()
	{
		return $this->belongsToMany('TipoIdentificacion', 'id');
	}

	public function genero()
	{
		return $this->belongsToMany('Genero', 'id');
	}

	public function paciente()
	{
		return $this->hasOne('Paciente', 'id');
	}

	public function usuario()
	{
		return $this->hasOne('User', 'id');
	}

}