<?php

namespace User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function tercero()
	{
		return $this->belongsTo('Tercero', 'id');
	}

	public function roles()
	{
		return $this->hasMany('RolesUsuarios', 'user_id');
	}

}