<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('group_id')->unsigned();
			$table->smallInteger('job_type_id')->unsigned();
			$table->string('gender', 100);
			$table->datetime('startAt');
			$table->datetime('endAt');
			$table->smallInteger('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
			$table->string('address', 255)->nullable();
			$table->datetime('birthdate');
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}