<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Entity extends Eloquent {

	protected $table = 'entities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'logo', 'short_description', 'description', 'socials', 'url', 'type', 'images');

	public function categories()
	{
		return $this->belongsToMany('App\Category');
	}

	public function news()
	{
		return $this->hasMany('App\New');
	}

	public function attributes()
	{
		return $this->morphMany('App\Attribute', 'attributable');
	}

	public function contents()
	{
		return $this->hasMany('App\EntityContent');
	}

}