<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoinsTable extends Migration {

	public function up()
	{
		Schema::create('coins', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('amount')->default('0');
			$table->enum('type', array('payment', 'review', 'affiliate'))->index();
			$table->enum('status', array('in', 'out'))->index();
		});
	}

	public function down()
	{
		Schema::drop('coins');
	}
}